function em = scaleEMachineSpd(em, rescaled_em_spd)
%scaleEMachine
%   rescaled_em_spd: rad/s

% Scaling factor
base_maxSpd = em.maxSpd;
scalingFactor = rescaled_em_spd/base_maxSpd;

em.maxSpd = rescaled_em_spd;

% Torque limit map
em.maxTrq.GridVectors{1} = em.maxTrq.GridVectors{1} * scalingFactor;
em.minTrq.GridVectors{1} = em.minTrq.GridVectors{1} * scalingFactor;

% Efficiency map
em.effMap.GridVectors{1} = em.effMap.GridVectors{1} * scalingFactor;

end

